<?php
session_start();
if (!isset($_SESSION['email'])) {
    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Home Page</title>
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
    }

    /* Navigation Bar */
    .navbar {
      display: flex;
      justify-content: space-between;
      align-items: center;
      background-color: #333;
      padding: 10px 20px;
    }

    .navbar .logo {
      color: #fff;
      font-size: 22px;
      font-weight: bold;
      text-decoration: none;
    }

    .navbar ul {
      list-style: none;
      margin: 0;
      padding: 0;
      display: flex;
    }

    .navbar ul li {
      margin-left: 20px;
    }

    .navbar ul li a {
      text-decoration: none;
      color: #fff;
      font-size: 16px;
      padding: 8px 12px;
      border-radius: 5px;
      transition: background 0.3s;
    }

    .navbar ul li a:hover {
      background-color: #555;
    }

    /* Page Content */
    .content {
      padding: 20px;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .navbar ul {
        flex-direction: column;
        display: none;
        background: #333;
        position: absolute;
        top: 60px;
        right: 0;
        width: 200px;
      }

      .navbar ul.active {
        display: flex;
      }

      .menu-toggle {
        display: block;
        cursor: pointer;
        color: #fff;
        font-size: 24px;
      }
    }

    .menu-toggle {
      display: none;
    }
  </style>
</head>
<body>

  <nav class="navbar">
    <a href="home_page.php" class="logo">MyWebsite</a>
    <span class="menu-toggle" onclick="toggleMenu()">☰</span>
    <ul id="menu">
      <li><a href="home_page.php">Home</a></li>
      <li><a href="enqueue_sms.php">send</a></li>
      <li><a href="view_replies.php">view Reply</a></li>
      <li><a href="#">Products</a></li>
      <li><a href="#">Contact</a></li>
      <li><a href="logout.php">Logout</a></li>
    </ul>
  </nav>

  <div class="content">
    <h1>Welcome, <?php echo $_SESSION['email']; ?> 🎉</h1>
    <p>You are now logged in to the website.</p>
  </div>

  <script>
    function toggleMenu() {
      document.getElementById("menu").classList.toggle("active");
    }
  </script>

</body>
</html>
