<?php
header("Content-Type: application/json");

// --- DB connection ---
$host = "localhost";       // usually 'localhost'
$user = "lawyersindian_data";    // your DB username
$pass = "Cpadmin@13";    // your DB password
$db   = "lawyersindian_data";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "DB connection failed"]);
    exit;
}

// --- Sanitize input ---
$action = isset($_GET['action']) ? $_GET['action'] : '';

if ($action === "fetch") {
    $device = isset($_GET['device']) ? $conn->real_escape_string($_GET['device']) : "";

    // Fetch pending messages for this device
    $sql = "SELECT id, mobile, message 
            FROM sms_queue 
            WHERE status='pending' AND device='$device'
            ORDER BY id ASC LIMIT 5";

    $res = $conn->query($sql);
    $jobs = [];
    while ($row = $res->fetch_assoc()) {
        $jobs[] = $row;
    }

    echo json_encode(["jobs" => $jobs]);

} elseif ($action === "ack") {
    // ESP32 posts: id=<id>&status=sent
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $status = isset($_POST['status']) ? $_POST['status'] : "";

    if ($id > 0 && in_array($status, ['sent','failed'])) {
        $sql = "UPDATE sms_queue SET status='$status' WHERE id=$id";
        $ok = $conn->query($sql);
        if ($ok) {
            echo json_encode(["success" => true]);
        } else {
            http_response_code(500);
            echo json_encode(["error" => "Update failed"]);
        }
    } else {
        http_response_code(400);
        echo json_encode(["error" => "Invalid parameters"]);
    }

} elseif ($action === "add") {
    // API to enqueue a new SMS job
    $device  = isset($_POST['device']) ? $conn->real_escape_string($_POST['device']) : "";
    $mobile  = isset($_POST['mobile']) ? $conn->real_escape_string($_POST['mobile']) : "";
    $message = isset($_POST['message']) ? $conn->real_escape_string($_POST['message']) : "";

    if ($device && $mobile && $message) {
        $sql = "INSERT INTO sms_queue (device, mobile, message) 
                VALUES ('$device', '$mobile', '$message')";
        $ok = $conn->query($sql);
        if ($ok) {
            echo json_encode(["success" => true, "id" => $conn->insert_id]);
        } else {
            http_response_code(500);
            echo json_encode(["error" => "Insert failed"]);
        }
    } else {
        http_response_code(400);
        echo json_encode(["error" => "Missing parameters"]);
    }

} else {
    http_response_code(400);
    echo json_encode(["error" => "Invalid action"]);
}

$conn->close();
?>
